$(document).ready(function () {

	$('.client-carousel').owlCarousel({
		loop: true,
		margin: 30,
		dots: true,
		nav: false,
		//		autoplay: true,
		animateOut: 'slideOutUp',
		responsive: {
			0: {
				items: 1
			},
			600: {
				items: 1
			},
			1000: {
				items: 2
			}
		}
	});
	
	$(".show-more").click(function() {
		if ($(".hidden_text").hasClass("show-more-height")) {
			$(this).text("(Show Less)");
		} else {
			$(this).text("(Show More)");
		}

		$(".hidden_text").toggleClass("show-more-height");
	});
        
    $(".scroll").click(function(e) {
        e.preventDefault();

        var position = $($(this).attr("href")).offset().top;

        $("body, html").animate({
            scrollTop: position
        }, 3000 );
    });

});


$.fn.jQuerySimpleCounter = function (options) {
	var settings = $.extend({
		start: 0,
		end: 100,
		easing: 'swing',
		duration: 400,
		complete: ''
	}, options);

	var thisElement = $(this);

	$({
		count: settings.start
	}).animate({
		count: settings.end
	}, {
		duration: settings.duration,
		easing: settings.easing,
		step: function () {
			var mathCount = Math.ceil(this.count);
			thisElement.text(mathCount);
		},
		complete: settings.complete
	});
};


$('#number1').jQuerySimpleCounter({
	end: 12,
	duration: 3000
});
$('#number2').jQuerySimpleCounter({
	end: 25,
	duration: 3000
});
$('#number3').jQuerySimpleCounter({
	end: 100,
	duration: 2000
});
$('#number4').jQuerySimpleCounter({
	end: 246,
	duration: 2500
});



/* AUTHOR LINK */
$('.about-me-img').hover(function () {
	$('.authorWindowWrapper').stop().fadeIn('fast').find('p').addClass('trans');
}, function () {
	$('.authorWindowWrapper').stop().fadeOut('fast').find('p').removeClass('trans');
});
