$(document).ready(function () {

    $(".testimonial_slider").owlCarousel({
        loop: true,
        margin: 0,
        autoplay: true,
        smartSpeed: 2000,
        autoplayTimeout: 4000,
        nav: true,
        dots: true,
        responsive: {
            0: {
                items: 1
            },
            560: {
                items: 2
            },
            1000: {
                items: 3
            }
        }
    });

    $(".product_slider").owlCarousel({
        loop: true,
        margin: 0,
        autoplay: true,
        smartSpeed: 2000,
        autoplayTimeout: 4000,
        nav: true,
        dots: true,
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 2
            },
            1000: {
                items: 3
            }
        }
    });  
        
    $(".scroll").click(function(e) {
        e.preventDefault();

        var position = $($(this).attr("href")).offset().top;

        $("body, html").animate({
            scrollTop: position
        }, 3000 );
    });

    $('body').append('<div id="toTop" class="btn btn-top">The <i class="ti-arrow-up"></i> Top</div>');
    $(window).scroll(function () {
        if ($(this).scrollTop() != 0) {
            $('#toTop').fadeIn();
        } else {
            $('#toTop').fadeOut();
        }
    });
    
    $('#toTop').on('click', function () {
        $("html, body").animate({scrollTop: 0}, 600);
        return false;
    });
    
    $('.nav-tabs > li ').hover(function() {
      if ($(this).hasClass('active'))
        return;
      else
        $(this).find('a').tab('show');
    });

});